
(* 1 flyway (actual physical) w/ 1 xbots - force mode ctrl,read payload,read flyway temps *)
FUNCTION_BLOCK Example19_force
	(*activate force mode control for xbot 1 in x axis 0 Newtons*)
	PMC_ForceModeCtrl1(PM_Controller := PM_Controller,Execute := Execute,Mode := 0,Level := 2,Buffer := 0,XbotID := 1,ForceX := 0,ForceY := 0,ForceZ := 0,TorqueZ := 0,PM_Controller := PM_Controller);

	(*start the weighing process for xbot 1*)
	PMC_WeighXbot1(PM_Controller := PM_Controller,Execute := PMC_ForceModeCtrl1.Done,XbotID := 1,Duration := 1.0,PM_Controller := PM_Controller);
	payload := PMC_WeighXbot1.Weight;

	(*lread power usage,CPU temp,amplifier temp, and motor temp of flyway 1*)
	PMC_GetFlywayStatus1(PM_Controller := PM_Controller,Execute := PMC_WeighXbot1.Done,FlywayID := 1,PM_Controller := PM_Controller);
	power := PMC_GetFlywayStatus1.Power;
	cpuTemp := PMC_GetFlywayStatus1.CPUTemp;
	PATemp := PMC_GetFlywayStatus1.PATemp;
	MTemp := PMC_GetFlywayStatus1.MTemp;

	(*wait 10 seconds*)
	Delay1(Execute := PMC_GetFlywayStatus1.Done,Cycles := 10000);

	(*exit force mode*)
	PMC_ForceModeCtrl2(PM_Controller := PM_Controller,Execute := Delay1.Done,Mode := 0,Level := 0,XbotID := 1,ForceX := 0,ForceY := 0,ForceZ := 0,TorqueZ := 0,PM_Controller := PM_Controller);

	Done := PMC_ForceModeCtrl2.Done;
END_FUNCTION_BLOCK
